#### Load Relevant Libraries ####
# install.packages( "MCMCpack" )
library( MCMCpack )
library( coda )

#### Read in Example Data from the GSS ####

gss.data <- read.csv( "Data/GSS Raw Data.csv" )

#### Clean Public Data by Coding Missing Data with NA and Reverse-coding When Applicable ####

gss.data <- within( gss.data, {
  health <- ifelse( HEALTH==0|HEALTH==8|HEALTH==9, NA, 5-HEALTH )
  wealth <- ifelse( REALINC==0|REALINC==999999|REALINC==999998, NA, REALINC )
  happiness <- ifelse( HAPPY==0|HAPPY==8|HAPPY==9, NA, 4-HAPPY )
})

example.data <- na.omit(with(gss.data, data.frame( health, wealth, happiness )))
#### Usable Sample Size After Listwise Deletion ####

final.n <- dim(example.data)[1]
print(final.n)

#### Classical Linear Model ####

model.1 <- glm( happiness ~ health , data=example.data )
summary(model.1) # Health Model
model.2 <- glm( happiness ~ wealth , data=example.data )
summary(model.2) # Wealth Model

#### Bayesian Model Comparison ####
BIC(model.1) # Health Model
BIC(model.2) # Wealth Model
abs( BIC(model.1) - BIC(model.2) )


#### Bayesian Linear Modelling ####

#### Generate 3 MCMC Chains with 5,000 Resamples Each, Using 500 Burn-in Samples ####

# Health Model
model.1.chain.1 <- MCMCregress( happiness ~ health , data=example.data, burnin=500, mcmc=5000, seed=abs(rnorm(1)*1000), b0=c(0, 0),
                                B0=c(1e-6, 1.6e-5),
                                c0=10, d0=4500000,marginal.likelihood="Chib95")
model.1.chain.2 <- MCMCregress( happiness ~ health , data=example.data, burnin=500, mcmc=5000, seed=abs(rnorm(1)*1000), b0=c(0, 0),
                                B0=c(1e-6, 1.6e-5),
                                c0=10, d0=4500000, marginal.likelihood="Chib95")
model.1.chain.3 <- MCMCregress( happiness ~ health , data=example.data, burnin=500, mcmc=5000, seed=abs(rnorm(1)*1000), b0=c(0, 0),
                                B0=c(1e-6, 1.6e-5),
                                c0=10, d0=4500000,marginal.likelihood="Chib95")
mcmc.model.1 <- mcmc.list( model.1.chain.1, model.1.chain.2, model.1.chain.3)

# Wealth Model
model.2.chain.1 <- MCMCregress( happiness ~ wealth , data=example.data, burnin=500, mcmc=5000, seed=abs(rnorm(1)*1000), b0=c(0, 0),
                                B0=c(1e-6, 1.6e-5),
                                c0=10, d0=4500000,marginal.likelihood="Laplace")
model.2.chain.2 <- MCMCregress( happiness ~ wealth , data=example.data, burnin=500, mcmc=5000, seed=abs(rnorm(1)*1000), b0=c(0, 0),
                                B0=c(1e-6, 1.6e-5),
                                c0=10, d0=4500000,marginal.likelihood="Chib95")
model.2.chain.3 <- MCMCregress( happiness ~ wealth , data=example.data, burnin=500, mcmc=5000, seed=abs(rnorm(1)*1000), b0=c(0, 0),
                                B0=c(1e-6, 1.6e-5),
                                c0=10, d0=4500000,marginal.likelihood="Chib95")
mcmc.model.2 <- mcmc.list( model.2.chain.1, model.2.chain.2, model.2.chain.3)

#### Evaluate the Quality of the MCMC Procedure ####
gelman.diag( mcmc.model.1 )
gelman.diag( mcmc.model.2 )

#### Autocorrelation ####
autocorr.diag( mcmc.model.1 )
autocorr.diag( mcmc.model.2 )

#### Print the Likely Parameter Estimates ####
summary( mcmc.model.1 )
summary( mcmc.model.2 )

#### Visualize Posterior Density ####
png( "Health Model.png" )
plot( mcmc.model.1 )
dev.off()

png( "Wealth Model.png" )
plot( mcmc.model.2 )
dev.off()

